/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollArea;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModContainer;

public class ClientConfigGui
extends Screen {
    private final int widget_height = 20;
    private final int start_top_offset = 5;
    private final int widget_x_offset = 16;
    private boolean dirtyFlag = true;
    private boolean accepted = false;
    private StringWidget battleListEditBoxStringWidget = null;
    private EditBox battleListEditBox = null;
    private StringWidget sillyListEditBoxStringWidget = null;
    private EditBox sillyListEditBox = null;
    private StringWidget sillyMusicThresholdSliderStringWidget = null;
    private SliderPercentage sillyMusicThresholdSlider = null;
    private StringWidget affectedByMasterVolCheckboxStringWidget = null;
    private Checkbox affectedByMasterVolCheckbox = null;
    private StringWidget affectedByMusicVolCheckboxStringWidget = null;
    private Checkbox affectedByMusicVolCheckbox = null;
    private StringWidget volumeSliderStringWidget = null;
    private SliderPercentage volumeSlider = null;
    private Screen parentScreen = null;
    private ScrollBar scrollBar = null;
    private double scrollAmount = 0.0;

    public ClientConfigGui(ModContainer container, Screen parent) {
        super((Component)Component.literal((String)"TurnBasedMC Client Config"));
        this.parentScreen = parent;
    }

    public void onDirty() {
        this.clearWidgets();
        int widget_width = this.width / 2 - 32;
        int top_offset = 5;
        if (this.scrollBar == null) {
            this.scrollBar = new ScrollBar(this.width - 16, 0, 16, this.height - 20);
        } else {
            this.scrollBar.setPosition(this.width - 16, 0);
            this.scrollBar.setSize(16, this.height - 20);
        }
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        if (this.battleListEditBoxStringWidget == null) {
            this.battleListEditBoxStringWidget = new StringWidget(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount(), widget_width, 20, (Component)Component.literal((String)"Battle Music Categories"), this.font);
        } else {
            this.battleListEditBoxStringWidget.setPosition(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.battleListEditBoxStringWidget.setSize(widget_width, 20);
        }
        this.addRenderableWidget((GuiEventListener)this.battleListEditBoxStringWidget);
        if (this.battleListEditBox == null) {
            this.battleListEditBox = new EditBox(this.font, this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount(), widget_width, 20, (Component)Component.literal((String)"Battle Music Categories Edit Box"));
        } else {
            this.battleListEditBox.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.battleListEditBox.setSize(widget_width, 20);
        }
        Object tempString = "";
        for (String category : (List)ClientConfig.CLIENT.battleMusicList.get()) {
            if (((String)tempString).isEmpty()) {
                tempString = category;
                continue;
            }
            tempString = (String)tempString + "," + category;
        }
        this.battleListEditBox.setMaxLength(128);
        this.battleListEditBox.setValue((String)tempString);
        this.addRenderableWidget((GuiEventListener)this.battleListEditBox);
        top_offset += 20;
        if (this.sillyListEditBoxStringWidget == null) {
            this.sillyListEditBoxStringWidget = new StringWidget(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount(), widget_width, 20, (Component)Component.literal((String)"Silly Music Categories"), this.font);
        } else {
            this.sillyListEditBoxStringWidget.setPosition(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.sillyListEditBoxStringWidget.setSize(widget_width, 20);
        }
        this.addRenderableWidget((GuiEventListener)this.sillyListEditBoxStringWidget);
        if (this.sillyListEditBox == null) {
            this.sillyListEditBox = new EditBox(this.font, this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount(), widget_width, 20, (Component)Component.literal((String)"Silly Music Categories Edit Box"));
        } else {
            this.sillyListEditBox.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.sillyListEditBox.setSize(widget_width, 20);
        }
        tempString = "";
        for (String category : (List)ClientConfig.CLIENT.sillyMusicList.get()) {
            if (((String)tempString).isEmpty()) {
                tempString = category;
                continue;
            }
            tempString = (String)tempString + "," + category;
        }
        this.sillyListEditBox.setMaxLength(128);
        this.sillyListEditBox.setValue((String)tempString);
        this.addRenderableWidget((GuiEventListener)this.sillyListEditBox);
        top_offset += 20;
        if (this.sillyMusicThresholdSliderStringWidget == null) {
            this.sillyMusicThresholdSliderStringWidget = new StringWidget(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount(), widget_width, 20, (Component)Component.literal((String)"Silly Music Threshold"), this.font);
            this.sillyMusicThresholdSliderStringWidget.setTooltip(Tooltip.create((Component)Component.literal((String)"Ratio of minimum of silly mobs in battle to play silly music")));
        } else {
            this.sillyMusicThresholdSliderStringWidget.setPosition(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.sillyMusicThresholdSliderStringWidget.setSize(widget_width, 20);
        }
        this.addRenderableWidget((GuiEventListener)this.sillyMusicThresholdSliderStringWidget);
        if (this.sillyMusicThresholdSlider == null) {
            this.sillyMusicThresholdSlider = new SliderPercentage(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount(), widget_width, 20, (Component)Component.literal((String)("Silly Music Threshold: " + String.format("%.1f%%", (Double)ClientConfig.CLIENT.sillyMusicThreshold.get() * 100.0))), (Double)ClientConfig.CLIENT.sillyMusicThreshold.get(), "Silly Music Threshold: ");
        } else {
            this.sillyMusicThresholdSlider.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.sillyMusicThresholdSlider.setSize(widget_width, 20);
        }
        this.addRenderableWidget((GuiEventListener)this.sillyMusicThresholdSlider);
        top_offset += 20;
        if (this.affectedByMasterVolCheckboxStringWidget == null) {
            this.affectedByMasterVolCheckboxStringWidget = new StringWidget(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount(), widget_width, 20, (Component)Component.literal((String)"Affected by Master Vol."), this.font);
            this.affectedByMasterVolCheckboxStringWidget.setTooltip(Tooltip.create((Component)Component.literal((String)"If enabled, volume is affected by global master volume.")));
        } else {
            this.affectedByMasterVolCheckboxStringWidget.setPosition(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.affectedByMasterVolCheckboxStringWidget.setSize(widget_width, 20);
        }
        this.addRenderableWidget((GuiEventListener)this.affectedByMasterVolCheckboxStringWidget);
        if (this.affectedByMasterVolCheckbox == null) {
            this.affectedByMasterVolCheckbox = Checkbox.builder((Component)Component.literal((String)""), (Font)this.font).pos(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount()).build();
        } else {
            this.affectedByMasterVolCheckbox.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
        }
        if (((Boolean)ClientConfig.CLIENT.volumeAffectedByMasterVolume.get()).booleanValue() && !this.affectedByMasterVolCheckbox.selected() || !((Boolean)ClientConfig.CLIENT.volumeAffectedByMasterVolume.get()).booleanValue() && this.affectedByMasterVolCheckbox.selected()) {
            this.affectedByMasterVolCheckbox.onPress();
        }
        this.addRenderableWidget((GuiEventListener)this.affectedByMasterVolCheckbox);
        top_offset += 20;
        if (this.affectedByMusicVolCheckboxStringWidget == null) {
            this.affectedByMusicVolCheckboxStringWidget = new StringWidget(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount(), widget_width, 20, (Component)Component.literal((String)"Affected by Music Vol."), this.font);
            this.affectedByMusicVolCheckboxStringWidget.setTooltip(Tooltip.create((Component)Component.literal((String)"If enabled, volume is affected by global music volume.")));
        } else {
            this.affectedByMusicVolCheckboxStringWidget.setPosition(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.affectedByMusicVolCheckboxStringWidget.setSize(widget_width, 20);
        }
        this.addRenderableWidget((GuiEventListener)this.affectedByMusicVolCheckboxStringWidget);
        if (this.affectedByMusicVolCheckbox == null) {
            this.affectedByMusicVolCheckbox = Checkbox.builder((Component)Component.literal((String)""), (Font)this.font).pos(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount()).build();
        } else {
            this.affectedByMusicVolCheckbox.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
        }
        if (((Boolean)ClientConfig.CLIENT.volumeAffectedByMusicVolume.get()).booleanValue() && !this.affectedByMusicVolCheckbox.selected() || !((Boolean)ClientConfig.CLIENT.volumeAffectedByMusicVolume.get()).booleanValue() && this.affectedByMusicVolCheckbox.selected()) {
            this.affectedByMusicVolCheckbox.onPress();
        }
        this.addRenderableWidget((GuiEventListener)this.affectedByMusicVolCheckbox);
        top_offset += 20;
        if (this.volumeSliderStringWidget == null) {
            this.volumeSliderStringWidget = new StringWidget(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount(), widget_width, 20, (Component)Component.literal((String)"Music Volume"), this.font);
            this.volumeSliderStringWidget.setTooltip(Tooltip.create((Component)Component.literal((String)"Volume of battle/silly music")));
        } else {
            this.volumeSliderStringWidget.setPosition(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.volumeSliderStringWidget.setSize(widget_width, 20);
        }
        this.addRenderableWidget((GuiEventListener)this.volumeSliderStringWidget);
        if (this.volumeSlider == null) {
            this.volumeSlider = new SliderPercentage(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount(), widget_width, 20, (Component)Component.literal((String)("Volume: " + String.format("%.1f%%", (Double)ClientConfig.CLIENT.musicVolume.get() * 100.0))), (Double)ClientConfig.CLIENT.musicVolume.get(), "Volume: ");
        } else {
            this.volumeSlider.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.volumeSlider.setSize(widget_width, 20);
        }
        this.addRenderableWidget((GuiEventListener)this.volumeSlider);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), b -> Minecraft.getInstance().setScreen(this.parentScreen)).bounds(this.width / 2 - widget_width + 16, this.height - 20, widget_width, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Accept"), b -> {
            this.accepted = true;
        }).bounds(this.width / 2 + 16, this.height - 20, widget_width, 20).build());
        this.scrollBar.setContentHeight((top_offset += 20) * 4);
        this.dirtyFlag = false;
    }

    private void doAccepted() {
        String temp = this.battleListEditBox.getValue();
        ArrayList<String> battleList = new ArrayList<String>();
        for (String category : temp.split(",")) {
            battleList.add(category.strip());
        }
        ClientConfig.CLIENT.battleMusicList.set(battleList);
        temp = this.sillyListEditBox.getValue();
        ArrayList<String> sillyList = new ArrayList<String>();
        for (String category : temp.split(",")) {
            sillyList.add(category.strip());
        }
        ClientConfig.CLIENT.sillyMusicList.set(sillyList);
        ClientConfig.CLIENT.sillyMusicThreshold.set((Object)this.sillyMusicThresholdSlider.percentage);
        ClientConfig.CLIENT.volumeAffectedByMasterVolume.set((Object)this.affectedByMasterVolCheckbox.selected());
        ClientConfig.CLIENT.volumeAffectedByMusicVolume.set((Object)this.affectedByMusicVolCheckbox.selected());
        ClientConfig.CLIENT.musicVolume.set((Object)this.volumeSlider.percentage);
        ClientConfig.CLIENT_SPEC.save();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.accepted) {
            this.doAccepted();
            Minecraft.getInstance().setScreen(this.parentScreen);
            return;
        }
        if (this.dirtyFlag) {
            this.onDirty();
        } else if (this.scrollBar != null && this.scrollAmount != this.scrollBar.scrollAmount()) {
            this.scrollAmount = this.scrollBar.scrollAmount();
            int widget_width = this.width / 2 - 32;
            int top_offset = 5;
            this.battleListEditBoxStringWidget.setPosition(this.width / 2 - widget_width + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.battleListEditBox.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.sillyListEditBoxStringWidget.setPosition(this.width / 2 - widget_width + 16, (top_offset += 20) - (int)this.scrollBar.scrollAmount());
            this.sillyListEditBox.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.sillyMusicThresholdSliderStringWidget.setPosition(this.width / 2 - widget_width + 16, (top_offset += 20) - (int)this.scrollBar.scrollAmount());
            this.sillyMusicThresholdSlider.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.affectedByMasterVolCheckboxStringWidget.setPosition(this.width / 2 - widget_width + 16, (top_offset += 20) - (int)this.scrollBar.scrollAmount());
            this.affectedByMasterVolCheckbox.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.affectedByMusicVolCheckboxStringWidget.setPosition(this.width / 2 - widget_width + 16, (top_offset += 20) - (int)this.scrollBar.scrollAmount());
            this.affectedByMusicVolCheckbox.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
            this.volumeSliderStringWidget.setPosition(this.width / 2 - widget_width + 16, (top_offset += 20) - (int)this.scrollBar.scrollAmount());
            this.volumeSlider.setPosition(this.width / 2 + 16, top_offset - (int)this.scrollBar.scrollAmount());
        }
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        this.dirtyFlag = true;
        super.resize(pMinecraft, pWidth, pHeight);
    }

    private static class SliderPercentage
    extends AbstractSliderButton {
        private final String messagePrefix;
        private double percentage;

        public SliderPercentage(int x, int y, int width, int height, Component message, double percentage, String messagePrefix) {
            super(x, y, width, height, message, percentage);
            this.percentage = percentage;
            this.messagePrefix = messagePrefix;
        }

        protected void updateMessage() {
            this.setMessage((Component)Component.literal((String)(this.messagePrefix + String.format("%.1f%%", this.percentage * 100.0))));
        }

        protected void applyValue() {
            this.percentage = this.value;
        }
    }

    private static class ScrollBar
    extends AbstractScrollArea {
        int contentHeight = 128;
        double scrollRate = 8.0;

        public ScrollBar(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.literal((String)"Client Config Scroll Bar"));
        }

        public void setContentHeight(int contentHeight) {
            this.contentHeight = contentHeight;
        }

        protected int contentHeight() {
            return this.contentHeight;
        }

        protected double scrollRate() {
            return this.scrollRate;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
            this.renderScrollbar(guiGraphics);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.add(NarratedElementType.TITLE, "TBMM Client Config Vertical Scroll Bar");
            narrationElementOutput.add(NarratedElementType.USAGE, "Scroll Vertically With Mouse Wheel");
        }
    }
}

