/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.AttackerViaBow;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.BattleManager;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.Config;
import com.burnedkirby.TurnBasedMinecraft.common.EditingInfo;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.Utility;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.network.PacketDistributor;

public class AttackEventHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAttackerValid(LivingAttackEvent event) {
        if (event.getSource().getEntity() == null) {
            return false;
        }
        if (event.getSource().getEntity().equals((Object)TurnBasedMinecraftMod.proxy.getAttackingEntity())) {
            return true;
        }
        long now = System.nanoTime();
        boolean isValid = false;
        Set<AttackerViaBow> set = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet();
        synchronized (set) {
            Iterator<AttackerViaBow> iter = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet().iterator();
            while (iter.hasNext()) {
                AttackerViaBow attacker = iter.next();
                if (now - attacker.attackTime >= AttackerViaBow.ATTACK_TIMEOUT) {
                    iter.remove();
                    continue;
                }
                if (!event.getSource().getEntity().equals((Object)attacker.entity) || !event.getSource().is(DamageTypes.ARROW)) continue;
                iter.remove();
                if (isValid) continue;
                Battle b = TurnBasedMinecraftMod.proxy.getBattleManager().getBattleByID(attacker.battleID);
                if (b != null) {
                    b.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ARROW_HIT, attacker.entity.getId(), event.getEntity().getId(), 0);
                }
                isValid = true;
            }
        }
        return isValid;
    }

    public static boolean entityAttacked(LivingAttackEvent event) {
        EditingInfo editingInfo;
        boolean ret = false;
        if (event.getEntity().level().isClientSide) {
            return ret;
        }
        CommonProxy proxy = TurnBasedMinecraftMod.proxy;
        Config config = proxy.getConfig();
        BattleManager battleManager = proxy.getBattleManager();
        if (event.getSource().getEntity() != null && event.getEntity() != null && (editingInfo = proxy.getEditingInfo(event.getSource().getEntity().getId())) != null && editingInfo.isPendingEntitySelection) {
            editingInfo.isPendingEntitySelection = false;
            ret = true;
            if (editingInfo.isEditingCustomName) {
                if (!event.getEntity().hasCustomName()) {
                    TurnBasedMinecraftMod.logger.error("Cannot edit custom name from entity without custom name");
                    TurnBasedMinecraftMod.getHandler().send((Object)new PacketGeneralMessage("Cannot edit custom name from entity without custom name"), PacketDistributor.PLAYER.with((Object)((ServerPlayer)editingInfo.editor)));
                    return ret;
                }
                editingInfo.entityInfo = config.getCustomEntityInfo(event.getEntity().getCustomName().getString());
                if (editingInfo.entityInfo == null) {
                    editingInfo.entityInfo = new EntityInfo();
                    editingInfo.entityInfo.customName = event.getEntity().getCustomName().getString();
                }
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketGeneralMessage("Editing custom name \"" + event.getEntity().getCustomName().getString() + "\""), PacketDistributor.PLAYER.with((Object)((ServerPlayer)editingInfo.editor)));
                TurnBasedMinecraftMod.logger.info("Begin editing custom \"" + event.getEntity().getCustomName().getString() + "\"");
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), PacketDistributor.PLAYER.with((Object)((ServerPlayer)editingInfo.editor)));
            } else {
                editingInfo.entityInfo = config.getMatchingEntityInfo(event.getEntity());
                if (editingInfo.entityInfo == null) {
                    editingInfo.entityInfo = new EntityInfo();
                    editingInfo.entityInfo.classType = event.getEntity().getClass();
                } else {
                    editingInfo.entityInfo = editingInfo.entityInfo.clone();
                }
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketGeneralMessage("Editing entity \"" + editingInfo.entityInfo.classType.getName() + "\""), PacketDistributor.PLAYER.with((Object)((ServerPlayer)editingInfo.editor)));
                TurnBasedMinecraftMod.logger.info("Begin editing \"" + editingInfo.entityInfo.classType.getName() + "\"");
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), PacketDistributor.PLAYER.with((Object)((ServerPlayer)editingInfo.editor)));
            }
            return ret;
        }
        if (event.getEntity() != null && event.getSource().getEntity() != null && (battleManager.isRecentlyLeftBattle(event.getEntity().getId()) || battleManager.isRecentlyLeftBattle(event.getSource().getEntity().getId()))) {
            ret = !(event.getSource().getEntity() instanceof Creeper) || !TurnBasedMinecraftMod.proxy.getConfig().getCreeperAlwaysAllowDamage();
            return ret;
        }
        if (!AttackEventHandler.isAttackerValid(event) && event.getEntity() != null && event.getSource().getEntity() != null && event.getEntity() != event.getSource().getEntity() && !config.getBattleIgnoringPlayers().contains(event.getSource().getEntity().getId()) && !config.getBattleIgnoringPlayers().contains(event.getEntity().getId()) && event.getEntity().level().dimension().equals((Object)event.getSource().getEntity().level().dimension()) && battleManager.checkAttack(event)) {
            ret = true;
        }
        if (TurnBasedMinecraftMod.proxy.getAttackingDamage() < (int)event.getAmount()) {
            TurnBasedMinecraftMod.proxy.setAttackingDamage((int)event.getAmount());
        }
        return ret;
    }

    public static void entityTargeted(LivingChangeTargetEvent event) {
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        BattleManager battleManager = TurnBasedMinecraftMod.proxy.getBattleManager();
        if (event.getEntity().level().isClientSide || config.isOldBattleBehaviorEnabled() || event.getEntity() != null && battleManager.isRecentlyLeftBattle(event.getEntity().getId()) || event.getNewTarget() != null && battleManager.isRecentlyLeftBattle(event.getNewTarget().getId()) || event.getEntity() != null && event.getNewTarget() != null && Utility.distanceBetweenEntities((Entity)event.getEntity(), (Entity)event.getNewTarget()) > (double)config.getAggroStartBattleDistance()) {
            return;
        }
        if (event.getEntity() != null && event.getNewTarget() != null && !config.getBattleIgnoringPlayers().contains(event.getEntity().getId()) && !config.getBattleIgnoringPlayers().contains(event.getNewTarget().getId()) && event.getEntity().level().dimension().equals((Object)event.getNewTarget().level().dimension())) {
            TurnBasedMinecraftMod.proxy.getBattleManager().checkTargeted(event);
        }
    }
}

